//=============================================================================
// SU_RepeatWindowFrame.js
// 
// Version: 0.1 2023/04/04
//============================================================================

var Imported = Imported || {};
Imported.SU_RepeatFrame = true;
var SU = SU || {};
SU.RepeatFrame = SU.RepeatFrame || {};

/*:
    * @plugindesc ウィンドウフレームのサンプリングを、引き延ばしではなく、リピートします
    * @author Su
    * @target MV
    *
    * @help
    * ============================================================================
    * 概要
    * ============================================================================
    * 通常、ウィンドウフレームの各角24px四方を除いた残りの辺は、ウィンドウの大きさに合わせて引き延ばされますが、
    * このプラグインでは素材を繰り返し継ぎ足してフレームを作成します。
    *
    * 注意点として、手法の性質上、素材によっては右側の辺と角の継ぎ目、下側の辺と角の継ぎ目が不自然になる可能性があります。
    * 
    * ============================================================================
    * 使い方
    * ============================================================================
    * パラメータやプラグインコマンドはありません。
    * On にしてるだけで適用されます。
    *
*/

(() => {
    (__refreshFrame_ => {
        Window.prototype._refreshFrame = function () {
            var w = this._width;
            var h = this._height;
            var m = 24;
            var bitmap = new Bitmap(w, h);

            this._windowFrameSprite.bitmap = bitmap;
            this._windowFrameSprite.setFrame(0, 0, w, h);

            if (w > 0 && h > 0 && this._windowskin) {
                var skin = this._windowskin;
                var p = 96;
                var q = 96;
                let l = p - m * 2;

                // 水平方向の辺の長さ
                const edgeLenHorizon = w - m * 2;
                // 垂直方向の辺の長さ
                const edgeLenVertical = h - m * 2;

                const x = p + m;
                for (let i = 0; i < Math.ceil(edgeLenHorizon / l); i++) {
                    let d = edgeLenHorizon - (l * i);
                    let realL = (d < l) ? d : l;
                    let dstX = m + l * i;

                    // 上辺の描画
                    bitmap.blt(skin, x, 0 + 0, realL, m, dstX, 0, realL, m);
                    // 下辺の描画
                    bitmap.blt(skin, x, 0 + q - m, realL, m, dstX, h - m, realL, m);
                }

                const y = m;
                for (let i = 0; i < Math.ceil(edgeLenVertical / l); i++) {
                    const d = edgeLenVertical - (l * i);
                    const realL = (d <= l) ? d : l;
                    const dstY = m + l * i;
                    // 左辺の描画
                    bitmap.blt(skin, p + 0, y, m, realL, 0, dstY, m, realL);
                    // 右辺の描画
                    bitmap.blt(skin, p + q - m, y, m, realL, w - m, dstY, m, realL);
                }

                // 左上角
                bitmap.blt(skin, p + 0, 0 + 0, m, m, 0, 0, m, m);
                // 右上角
                bitmap.blt(skin, p + q - m, 0 + 0, m, m, w - m, 0, m, m);
                // 左下角
                bitmap.blt(skin, p + 0, 0 + q - m, m, m, 0, h - m, m, m);
                // 右下角
                bitmap.blt(skin, p + q - m, 0 + q - m, m, m, w - m, h - m, m, m);
            }

        }
    })(Window.prototype._refreshFrame);
})();